# Changelog - CSVtoXL

All notable changes to this project will be documented in this file.

## [2.0.0] - 2026-02-25

### Features & Improvements (2.0.0)

- **New Modern Dashboard GUI**: A complete overhaul using CustomTkinter with Dark/Light mode support.
- **Drag & Drop Support**: Just drop one or multiple CSVs onto the dashboard.
- **Batch Processing**: Convert multiple CSV files concurrently significantly faster.
- **Merge Options**: Combine multiple CSV files into separate Excel tabs or append them together.
- **Dynamic Live Preview**: Instant 5x5 preview matrix that adapts colors to the chosen Excel theme.
- **Freemium Licensing**: Added a new tier structure with premium features bound to hardware signatures.
- **Unit Tests**: Introduced `tests/` directory with test coverage for internal libraries.

## [1.8.1] - 2026-02-19

- **Crash Fix**: Resolved `AttributeError` on startup (corrected GUI initialization order).

## [1.8.0] - 2026-02-19

### Features (1.8.0)

- **Full Bilingual Support**:
  - Context Menu shortcut now translates ("Convert with CSVtoXL").
  - Excel Template names are now available in English and German.
- **Documentation**: Split into `README.md` (English) and `README.de.md` (German) for better accessibility.

## [1.7.0] - 2026-02-19

### Features (1.7.0)

- **Bilingual Interface**: The UI can now be toggled between German (DE) and English (EN).
- **Git Cleanup**: Removed `backlog.md` and `config.json` from the repository (local files remain).

## [1.6.0] - 2026-02-19

### Features & Improvements (1.6.0)

- **Filter Option**: New setting "Enable filtering" to control Excel AutoFilters.
- **Workflow**: Removed "Saved" confirmation dialog (Silent Save) for faster workflow. Removed Email function.
- **Styles**: Corrected and improved color mappings (Red, Green, Orange). "Red" now uses `TableStyleMedium 3`.
- **Bugfixes**: Explorer now correctly opens custom output folders. App icon is reliably displayed.

## [1.5.0] - 2026-02-19

### Added (1.5.0)

- **Settings GUI**: A minimalist window opens when starting the `.exe` (without arguments). All options can be configured via click.
- **Custom Styles**: Custom Excel Style names (e.g., `TableStyleDark1`) can now be used via the GUI.
- **Integration Manager**: Context menu and "Send to" shortcuts can now be activated or removed directly from the app.

## [1.4.0] - 2026-02-19

### Added (1.4.0)

- **Windows Integration**: Internal logic for setting up context menus.
- **Performance Optimization**: Column widths are now calculated vector-dynamically (significantly faster for files > 1MB).
- **Smart Sampling**: For very large files, width is estimated based on a sample (first 3000 rows).

## [1.3.2] - 2026-02-17

### Fixed (1.3.2)

- **Auto-Width Crash Fix**: Fixed `TypeError: object of type 'float' has no len()` which could occur with empty fields (NaN) during column width calculation.

## [1.3.1] - 2026-02-12

### Fixed (1.3.1)

- **Auto-Open Fix**: Fixed issue where `config.json` was sometimes ignored and the Excel file could not be opened automatically.
- **Extended Logging**: Detailed process logging in `CSVtoXL.log`.

## [1.3] - 2026-02-12

### Added (1.3)

- **Metadata**: The `.exe` now contains professional file information (Version 1.3, Product Name, License).
- **Error Log**: Automatically creates `CSVtoXL.log` on crashes or errors to failitate debugging.

## [1.2] - 2026-02-12

### Removed / Changed (1.2)

- **SMTP Removed**: Background email sending was replaced by opening the default email client.

### Added (1.2)

- **Email Client Integration**: New option `open_email_client` opens the local mail client (e.g., Outlook) with the file attached.

## [1.1] - 2026-02-12

### Added (1.1)

- Option to directly open the Excel file after conversion (`auto_open_file`).

## [1.0] - 2026-02-12

### Added (1.0)

- First official release as **CSVtoXL**.
- Premium Design (Dark Blue) as default.
- Freeze Panes (top row fixed).
- Auto-Column Width.
- Automatic CSV delimiter detection.
- Header cleaning.
- Configuration file `config.json` with auto-sync of new keys.
- Portable build without console, with icon.
- GitHub Integration and Release folder structure.
