# CSVtoXL - CSV to Excel Converter

![Release](https://img.shields.io/github/v/release/sphadoinkl/CSVtoXL?label=version)

**CSVtoXL** is a lightweight, portable Windows tool that converts CSV files into formatted Excel tables (`.xlsx`). It requires no installation and offers smart features like auto-detection of delimiters, encoding, and cleaning of headers.

## Features

- **Modern Dashboard**: Manage single files, batches, and merges via a sleek user interface (Dark/Light mode).
- **Drag & Drop**: Simply drop CSV files into the application to process them.
- **Batch Processing**: Convert multiple CSV files concurrently with a single click.
- **Merge Options**: Combine multiple CSVs into separate Excel tabs, or append them as rows.
- **Auto-Detection**: Automatically detects delimiters (`;`, `,`) and encoding (UTF-8, Latin1, CP1252).
- **Smart Formatting**: Converts CSV data into a real Excel table with sortable headers.
- **Design Presets**: Choose from various professional Excel styles (Blue, Grey, Green, etc.).
- **Bilingual**: Interface available in **English** and **German**.
- **Windows Integration**: Add context menu ("Convert with CSVtoXL") and "Send to" shortcuts.
- **Configurable**:
  - **Auto-Open**: Optionally open Explorer or the file after conversion.
  - **Filtering**: Enable/disable Excel AutoFilters.
  - **Freeze Rows**: Freeze the top header row automatically.

## Usage

1. **Double-click** `CSVtoXL.exe` to open the **Dashboard**.
   - Review live previews of your CSV data before converting.
   - Configure language, design, and settings on the left sidebar.
2. **Drag & Drop** one or multiple CSV files onto the dashboard.
3. Use the **Batch** or **Merge** tabs to process multiple files simultaneously.
4. Or **Right-click** a CSV file and select **Convert with CSVtoXL** (if Windows integration is enabled).

The converted `.xlsx` file is saved in the same directory as the source file (or a custom output directory if configured).
